#include "stdafx.h"
#include "version.h"
#include "DffExp.h"
#include "RwExp.h"
#include "DffDlg.h"
#include "WarningsDlg.h"
#include "RwExpError.h"
#include "osutils.h"

//extension of report file generated after export (same name as DFF)
#define ReportFileExtension ".TXT"

/*

DFFExport.cpp:  DFFExport plugin's interface to MAX and top level user interface

*/

DFFExport::DFFExport(void)
{
}

DFFExport::~DFFExport(void)
{
}

int
DFFExport::DoExport(const TCHAR *filename, ExpInterface *ei, Interface *gi, BOOL suppressPrompts, DWORD options)
{
    CDffDlg dlg;

    /* setup & display the DFF export dialog */
    /* suppress prompts is included for the batch export from maxscript.
       This option simply exports using the current registry settings,
       which have hopefully been loaded in from a reg file. */
    dlg.m_suppressPrompts=suppressPrompts;
    if (dlg.DoModal() == IDOK)
    {
        m_nScaleFactor = dlg.m_nScaleFactor;
        m_anim = dlg.m_anim;
        m_morphTargets = dlg.m_morphTargets;
        m_nScaleType = dlg.m_nScaleType;
        m_preLightClump = dlg.m_preLightClump;
        m_seqAnim = dlg.m_seqAnim;
        m_nAnimFrameInterval = dlg.m_nAnimFrameInterval;
        m_retainObjInWorldSpace = dlg.m_retainObjInWorldSpace;
        m_linkBySelSets = dlg.m_linkBySelSets;
        m_triStripMesh = dlg.m_triStripMesh;
        m_limitUVs = dlg.m_limitUVs;
        m_limitUVMax = dlg.m_limitUVMax;
        if (m_limitUVMax > 1)
        {
            /*  Since we only limit low uv coord of each polygon
                subtracting 1 will ensure all triangles with 1
                uv tile or less will be mapped 0->m_limitUVMax */
            m_limitUVMax--;
        }
        m_weldThreshold = dlg.m_weldThreshold;
        m_weldThresholdUV = dlg.m_weldThresholdUV;
        m_backfaceNormals = dlg.m_backfaceNormals;
        m_2SidedMaterials = dlg.m_2SidedMaterials;
        m_CSExport = dlg.m_CSExport;
        m_maxNativeSkin = dlg.m_maxNativeSkin;
        m_exportNormals = dlg.m_exportNormals;
        m_exportLit = dlg.m_exportLit;
        m_colorVertexPrelight = dlg.m_colorVertexPrelight;
        m_weldVertices = dlg.m_weldVertices;
        if (dlg.m_defaultAnimName && strlen(dlg.m_defaultAnimName) > 0)
        {
            m_defaultAnimName = _strdup(dlg.m_defaultAnimName);
        }
        else
        {
            m_defaultAnimName = _strdup("default");
        }
        m_noExtraInterpKeys = dlg.m_NoExtraInterpKeys;
        m_skinning = m_CSExport || m_linkBySelSets ||m_maxNativeSkin;
        m_texturenameCase = dlg.m_texturenameCase;
        m_exportLabels = dlg.m_exportLabels;
        m_filterTopLevelCSKeys = dlg.m_filterTopLevelCSKeys;
        m_generateReportFile = dlg.m_generateReportFile;
        m_displayReport = dlg.m_displayReport;
        m_legacyOptions = dlg.m_legacyOptions;
        m_skinSKA = dlg.m_skinSKA;
        m_exportHAnim = dlg.m_exportHAnim;
        m_HAnimLocalSpaceMatrices = dlg.m_HAnimLocalSpaceMatrices;
        m_HAnimNoMatrices = dlg.m_HAnimNoMatrices;
        m_HAnimSubHierarchyAnim = dlg.m_HAnimSubHierarchyAnim;

    }
    else
    {
        return (TRUE);
    }

    /* set up a wait cursor */
    CWaitCursor waitCursor;

    try
    {
        hGMaxHWnd = gi->GetMAXHWnd();

        /*
        Open up RenderWare
        (destructor called when this function exits will close RenderWare - no need to delete!)
        Needs to be in try block because Renderware assertions
        are overloaded to throw RwExpErrors which are caught below.
        */
        RwLib rwlib(hGMaxHWnd, m_seqAnim || m_anim || m_skinning, m_skinning, FALSE, TRUE, FALSE, m_exportLabels, m_exportHAnim);

        /* check RW opened */
        if (!rwlib.Opened())
        {
            MessageBox(hGMaxHWnd, "Failed to open RenderWare",DFFExporterTitle, MB_OK );
            return TRUE;
        }

        m_WarningsList.zeroMetrics();
        m_WarningsList.writeVersion();
        
        //now the real work
        RwExpError errMsg = TraverseScene(filename, gi );

        char temp[256];
        sprintf(temp,"Export totals #1: Clumps=%i Frames=%i Atomics=%i Vertices=%i Triangles=%i",
            m_WarningsList.m_ClumpCount,
            m_WarningsList.m_FrameCount,
            m_WarningsList.m_AtomicCount,    
            m_WarningsList.m_VertexCount,
            m_WarningsList.m_TriangleCount );
        m_WarningsList.add(CWarning(wtInformational,"",temp));
        sprintf(temp,"Export totals #2: Rot Keys=%i Trans Keys=%i",
            m_WarningsList.m_RotKeys,
            m_WarningsList.m_TransKeys );
        m_WarningsList.add(CWarning(wtInformational,"",temp));
        if (CSNumBones>0) {
            sprintf(temp,"Export totals #3: Exported %i bones",CSNumBones );
        }
        else {
            sprintf(temp,"Export totals #3: No bones exported");
        }
        m_WarningsList.add(CWarning(wtInformational,"",temp));

        if (errMsg.Explanation() != "")
        {
            //user did something wrong & we couldn't export
            MessageBox(hGMaxHWnd, errMsg.Explanation().c_str(),
                DFFExporterTitle, MB_OK|MB_ICONSTOP );
        }
        else
        {
            //export more or less successful, list warnings & information
            if (m_generateReportFile) {
                string ReportFilename;
                FILE *fd;

                ReportFilename=ChangeFileExtension(filename,ReportFileExtension);
                
                fd=fopen(ReportFilename.c_str(),"w");
                if (fd) {
                    //write out the export time
                    CTime theTime = CTime::GetCurrentTime();
                    CString s = theTime.Format( "%A, %B %d, %Y %H:%M" );
                    LPSTR p=s.GetBuffer(256);
                    fprintf(fd,"Exported on %s\n",p);
                    s.ReleaseBuffer();

                    //write out status of export buttons on UI
                    fprintf(fd,"Scale Factor=%f\n",dlg.m_nScaleFactor);
                    fprintf(fd,"Anim=%i\n",dlg.m_anim);
                    fprintf(fd,"Morph Targets=%i\n",dlg.m_morphTargets);
                    fprintf(fd,"Scale Type=%i\n",dlg.m_nScaleType);
                    fprintf(fd,"Prelight clump=%i\n",dlg.m_preLightClump);
                    fprintf(fd,"Sequence animation=%i\n",dlg.m_seqAnim);
                    fprintf(fd,"Animation frame interval=%i\n",dlg.m_nAnimFrameInterval);
                    fprintf(fd,"Retain object in world space=%i\n",dlg.m_retainObjInWorldSpace);
                    fprintf(fd,"Link by selection sets=%i\n",dlg.m_linkBySelSets);
                    fprintf(fd,"Tri strip mesh=%i\n",dlg.m_triStripMesh);
                    fprintf(fd,"Limit UVs=%i\n",dlg.m_limitUVs);
                    fprintf(fd,"Limit UV max=%i\n",dlg.m_limitUVMax);
                    fprintf(fd,"Weld threshold=%f\n",dlg.m_weldThreshold);
                    fprintf(fd,"Weld thresholdUV=%f\n",dlg.m_weldThresholdUV);
                    fprintf(fd,"Backface normals=%i\n",dlg.m_backfaceNormals);
                    fprintf(fd,"Two sided materials=%i\n",dlg.m_2SidedMaterials);
                    fprintf(fd,"Character studio export=%i\n",dlg.m_CSExport);
                    fprintf(fd,"Filter top level CS keys=%i\n",dlg.m_filterTopLevelCSKeys);
                    fprintf(fd,"Link by selection sets=%i\n",dlg.m_linkBySelSets);
                    fprintf(fd,"Max native skin=%i\n",dlg.m_maxNativeSkin);
                    fprintf(fd,"Export normals=%i\n",dlg.m_exportNormals);
                    fprintf(fd,"Export lit=%i\n",dlg.m_exportLit);
                    fprintf(fd,"Colour vertex prelight=%i\n",dlg.m_colorVertexPrelight);
                    fprintf(fd,"Weld vertices=%i\n",dlg.m_weldVertices);
                    fprintf(fd,"Default name=%s\n",dlg.m_defaultAnimName);
                    fprintf(fd,"No extra interpolation keys=%i\n",dlg.m_NoExtraInterpKeys);
                    fprintf(fd,"Texture name case=%i\n",dlg.m_texturenameCase);
                    fprintf(fd,"Export labels=%i\n",dlg.m_exportLabels);
                    fprintf(fd,"Generate report file=%i\n",dlg.m_generateReportFile);
                    fprintf(fd,"Display report=%i\n",dlg.m_displayReport);
                    fprintf(fd,"Legacy Options=%i\n",dlg.m_legacyOptions);
                    fprintf(fd,"Export HAnim=%i\n",dlg.m_exportHAnim);
                    fprintf(fd,"Skin SKA=%i\n",dlg.m_skinSKA);
	                fprintf(fd,"HAnim no matrices=%i\n",dlg.m_HAnimNoMatrices);
                    fprintf(fd,"HAnim SubHierarchy anim=%i\n",dlg.m_HAnimSubHierarchyAnim);
                    fprintf(fd,"HAnim local space matrices=%i\n",dlg.m_HAnimLocalSpaceMatrices);
                    fprintf(fd,"\n");

                    fprintf(fd,"Warning list:\n");
                    m_WarningsList.saveToFile(fd);
                    fclose(fd);
                }
            }
            if (!suppressPrompts) {
                if (m_displayReport) {
                    CWarningsDlg WarningsDlg;
                    WarningsDlg.setWarningsList(&m_WarningsList);
                    WarningsDlg.DoModal();
                }
            }
        }
    }
    catch (RwExpError &err)
    {
        //export impossible, probably a bug, display error message and exit gracefully
        //i.e. DON'T crash MAX.
        err.Display();
    }

    return TRUE;
}
